<?php
/*======================================================================*\
|| #################################################################### ||
|| # v3 Arcade for vBulletin                                          # ||
|| # Support: http://www.v3arcade.com                                 # ||
|| # Copyright: http://www.cinvin.com                                 # ||
|| #################################################################### ||
\*======================================================================*/

// ##### Getmicrotime #########################################################
function getmicrotime()
{
	list($usec, $sec) = explode(' ', microtime());
	return sprintf('%.4f', ($usec + $sec));
}

// ##### Format a score #######################################################
function v3_score_format($value)
{
	return vb_number_format($value, (strpos($value, '.000') ? 0 : 3));
}

// ##### Ordinal - Add suffix to rank numbers #################################
function ordinal($number)
{
	if ($number % 100 > 10 AND $number %100 < 14)
	{
		$suffix = 'th';
	}
	else
	{
		switch($number % 10)
		{
			case 0:
				$suffix = 'th';
			break;
			case 1:
				$suffix = 'st';
			break;
			case 2:
				$suffix = 'nd';
			break;
			case 3:
				$suffix = 'rd';
			break;
			default:
				$suffix = 'th';
			break;
		}
	}

	return '<sup>' . $suffix . '</sup>';
}

// ##### Convert seconds to hour/minute/second ################################
function sec2hms($sec, $full = true)
{
	global $vbphrase;

	$hours = intval($sec / 3600);
	$minutes = intval(($sec / 60) % 60);
	$seconds = intval($sec % 60);

	if ($full)
	{
		return $hours . ' ' . $vbphrase['hours'] . ', '
			. $minutes . ' ' . $vbphrase['minutes'] . ', '
			. $seconds . ' ' . $vbphrase['seconds'];
	}
	else
	{
		if ($minutes < 10)
		{
			$minutes = '0' . $minutes;
		}
		if ($seconds < 10)
		{
			$seconds = '0' . $seconds;
		}

		return ($hours ? $hours . ':' : '') . ($minutes ? $minutes . ':' : '') . $seconds;
	}
}

// ##### Print Award Image ####################################################
function arcade_award_img($game)
{
	global $vbulletin;

	switch ($vbulletin->options['arcadeawards'])
	{
		case 1:
			return 'trophy.gif';
		break;

		case 2:
		case 3:
			return 'crown1.gif';
		break;

		case 4:
			return $game['miniimage'];
		break;
	}
}

// ##### Print Scores Row #####################################################
function fetch_arcade_score_row($score, $highscore = false)
{
	global $vbulletin, $vbphrase, $parser, $show, $stylevar, $bgclass, $altbgclass;
	global $scorebits, $placecounter, $pagenumber, $game;

	if ($placecounter == 1)
	{
		$scorebittemplate = 'v3arcade_scorebit_high';

		$score['avatar'] = fetch_avatar_url($score['userid']);
		$score['useravatar'] = $score['avatar'][0];
		$score['avdimensions'] = $score['avatar'][1];

		// If the user has no avatar, use the default placeholder.
		if (!$score['useravatar'])
		{
			$score['useravatar'] = $vbulletin->options['arcadeimages'] . '/noavatar.gif';
		}
	}
	else
	{
		$scorebittemplate = 'v3arcade_scorebit';
	}

	// Calculates the session's length.
	$score['sessionlength'] = sec2hms($score['finish'] - $score['start'], false);
	$score['date'] = vbdate($vbulletin->options['scoredateformat'], $score['finish']);
	$score['score'] = v3_score_format($score['score']);

	if (!$highscore)
	{
		$score['comment'] = $parser->do_parse(
			$score['comment'],
			$vbulletin->options['comments_allowhtml'],
			$vbulletin->options['comments_allowsmilies'],
			$vbulletin->options['comments_allowbbcode'],
			$vbulletin->options['comments_allowimgcode'],
			0
		);
	}

	($hook = vBulletinHook::fetch_hook('arcade_score_row')) ? eval($hook) : false;

	exec_switch_bg();

	// Spit out the row.
	eval('$scorebits .= "' . fetch_template($scorebittemplate) . '";');

	$placecounter++;
}

// ##### Fetch Award ##########################################################
function fetch_arcade_award_img(&$game)
{
	global $vbulletin, $show;

	if (!$vbulletin->options['v3profile_awardimg'])
	{
		return '';
	}

	switch ($vbulletin->options['arcadeawards'])
	{
		// single crown
		case 2:
			$game['miniimage'] = 'crown1.gif';
			$show['awardimgbit'] = true;
		break;

		// multi-color crowns
		case 3:
			$game['miniimage'] = $game['imgname'];
			$show['awardimgbit'] = true;
		break;

		// mini image is already set
		case 4:
		break;

		default:
			$game['miniimage'] = 'trophy.gif';
			$show['awardimgbit'] = true;
	}
	
	return $game['miniimage'];
}

// ##### Fetch Member Awardbits ###############################################
function fetch_member_award_bits($userid)
{
	global $vbulletin, $vbphrase, $show;
	
	$show['champgames'] = true;
	$show['isfirstgame'] = true;

	foreach ($vbulletin->v3a_awards[$userid] AS $gameid => $game)
	{
		fetch_arcade_award_img($game);

		if ($vbulletin->options['v3profile_awardimg'])
		{
			$game['stdimage'] = $game['miniimage'];
		}

		$game['linktitle'] = construct_phrase($vbphrase['x_y_points'], $game['title'], v3_score_format($game['highscore']));
		eval('$images .= "' . fetch_template('memberinfo_v3arcade_gamebits') . '";');
		$show['isfirstgame'] = false;
	}
	
	return $images;
}

// ##### Insert Arcade News ###################################################
function insert_arcade_news($text, $newstype = 'auto')
{
	global $db;

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "v3arcade_news
			(newstext, newstype, datestamp)
		VALUES (
			'" . $db->escape_string($text) . "',
			'$newstype',
			" . TIMENOW . "
	)");

	build_arcade_news_cache();
}

// ##### Update News Cache ####################################################
function build_arcade_news_cache()
{
	global $vbulletin;

	$cache = array(
		'newslimit' => $vbulletin->options['arcade_newslimit'],
		'newsevents' => array()
	);

	$newsquery = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "v3arcade_news AS arcade_news
		ORDER BY datestamp DESC
		LIMIT " . $vbulletin->options['arcade_newslimit']
	);
	while ($news = $vbulletin->db->fetch_array($newsquery))
	{
		$cache['newsevents'][] = $news;
	}

	build_datastore('v3a_news', serialize($cache), 1);

	return $cache;
}

// ##### Cache Awards #########################################################
function build_arcade_award_cache()
{
	global $vbulletin;

	if (!$vbulletin->options['arcadeawards']) 
	{
		build_datastore('v3a_awards', serialize(array()), 1);
		return false;
	}
		
	// multi-color crowns 
	if ($vbulletin->options['arcadeawards'] == 3) 
	{ 
		$crownimages = range(1, 8); 
	} 

	$cache = array(); 
	$awards = $vbulletin->db->query_read(" 
		SELECT gameid, title, highscorerid, highscore, miniimage, stdimage
		FROM " . TABLE_PREFIX . "v3arcade_games 
		WHERE highscorerid IS NOT NULL 
			AND (gamepermissions & " . $vbulletin->bf_misc_gamepermissions['showaward'] . ") 
		ORDER BY gameid 
	"); 
	while ($award = $vbulletin->db->fetch_array($awards)) 
	{ 
		// multi-color crowns 
		if ($vbulletin->options['arcadeawards'] == 3) 
		{ 
			$award['imgname'] = 'crown' . current($crownimages) . '.gif'; 
			if (!next($crownimages)) 
			{ 
				reset($crownimages); 
			} 
		} 

		$cache[$award['highscorerid']][$award['gameid']] = $award; 
	} 

	build_datastore('v3a_awards', serialize($cache), 1);
}

// ##### Cache Tournament Data ################################################
function build_tournament_cache()
{
	global $vbulletin, $db;

	$cache = array();

	$tourcounts = array();
	$gettours = $db->query_read("
		SELECT status, COUNT(*) AS statuscnt
		FROM " . TABLE_PREFIX . "v3arcade_tournaments
		GROUP BY status
	");
	while ($tour = $db->fetch_array($gettours))
	{
		$tourcounts[$tour['status']] = $tour['statuscnt'];
		$cache['tourdata']['total'] += $tour['statuscnt'];
	}

	$cache['tourdata']['awaiting'] = $tourcounts['0'];
	$cache['tourdata']['active'] = $tourcounts['1'];
	$cache['tourdata']['finished'] = $tourcounts['2'];

	$db->free_result($gettours);

	// Tournaments - Most wins
	$mosttourwins = 0;
	$getmosttours = $db->query_read("
		SELECT COUNT(tournaments.winner) as numwins, tournaments.winner, user.username
		FROM " . TABLE_PREFIX . "v3arcade_tournaments AS tournaments
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (tournaments.winner = user.userid)
		WHERE tournaments.status = 2
		GROUP BY tournaments.winner
		ORDER BY numwins DESC
		LIMIT 3
	");
	while ($tour = $db->fetch_array($getmosttours))
	{
		if ($mosttourwins AND $tour['numwins'] != $mosttourwins)
		{
			continue;
		}

		$mosttour_winners .= $winscomma . '<a href="member.php?u=' . $tour['winner'] . '&amp;tab=v3arcade_stats">' . $tour['username'] . '</a>';
		$mosttourwins = $tour['numwins'];
		$winscomma = ', ';
	}

	$db->free_result($getmosttours);

	$cache['mostwins'] = array(
		'winner' => $mosttour_winners,
		'numwins' => $mosttourwins
	);

	build_datastore('v3a_tournament', serialize($cache), 1);

	return $cache;
}

// ##### Update Finished Tournament Cache #####################################
function build_finished_challenge_cache()
{
	global $vbulletin;

	$cache = array(
		'challengelimit' => $vbulletin->options['frontminichallenges'],
		'challenges' => array()
	);

	$challenges = $vbulletin->db->query_read("
		SELECT challenges.*, touser.username AS tousername, fromuser.username AS fromusername, games.miniimage, games.title
		FROM " . TABLE_PREFIX . "v3arcade_challenges AS challenges
		LEFT JOIN " . TABLE_PREFIX . "user AS touser ON (touser.userid = challenges.touserid)
		LEFT JOIN " . TABLE_PREFIX . "user AS fromuser ON (fromuser.userid = challenges.fromuserid)
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS games ON (games.gameid = challenges.gameid)
		WHERE status = 3
		ORDER BY datestamp DESC
		LIMIT " . $vbulletin->options['frontminichallenges']
	);
	while ($challenge = $vbulletin->db->fetch_array($challenges))
	{
		$cache['challenges'][$challenge['challengeid']] = $challenge;
	}

	build_datastore('v3a_challenge', serialize($cache), 1);

	return $cache;
}

// ##### Update Latest Scores Cache ###########################################
function build_arcade_latest()
{
	global $vbulletin;

	if (!$vbulletin->options['arcadelatescores'])
	{
		return false;
	}

	$cache = array(
		'scoreslimit' => $vbulletin->options['arcadelatescores'],
		'scores' => array()
	);

	// Show the latest scores, excluding tournament events
	$latest = $vbulletin->db->query_read("
		SELECT sessions.*, games.title, user.username
		FROM " . TABLE_PREFIX . "v3arcade_sessions AS sessions
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS games ON (sessions.gameid = games.gameid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (sessions.userid = user.userid)
		WHERE valid = 1
			AND tourid = 0
		ORDER BY finish DESC
		LIMIT " . $vbulletin->options['arcadelatescores']
	);
	while ($late = $vbulletin->db->fetch_array($latest))
	{
		$late['score'] = v3_score_format($late['score']);
		$cache['scores'][] = $late;
	}

	build_datastore('v3a_newscores', serialize($cache), 1);

	return $cache;
}

// ##### Update Champion Cache ################################################
function build_arcade_champ_cache()
{
	global $vbulletin;

	if (!$vbulletin->options['arcadechamps'])
	{
		return;
	}

	$cache = array();
	$getchamps = $vbulletin->db->query_read("
		SELECT games.highscorerid, user.username, user.userid
		FROM " . TABLE_PREFIX . "v3arcade_games AS games
		INNER JOIN " . TABLE_PREFIX . "user AS user ON (games.highscorerid = user.userid)
	");
	while ($champs = $vbulletin->db->fetch_array($getchamps))
	{
		$cache[$champs['highscorerid']]['count']++;
		$cache[$champs['highscorerid']]['username'] = $champs['username'];
		$cache[$champs['highscorerid']]['userid'] = $champs['highscorerid'];
	}
	$vbulletin->db->free_result($getchamps);

	uasort($cache, 'order_scores');

//	$cache = array_slice($cache, 0, $vbulletin->options['arcadechamps']);

	$ccount = 0;
	$arcadechamps = '';
	foreach (array_keys($cache) AS $suserid)
	{
		$ccount++;

		if ($cache[$suserid]['count'] == $lastcount)
		{
			$rank = $lastrank;
		}
		else
		{
			$rank = $ccount;
			$lastcount = $cache[$suserid]['count'];
			$lastrank = $rank;
		}

		$cache[$suserid]['rank'] = $rank . ordinal($rank);
	}

	build_datastore('v3a_champs', serialize($cache), 1);

	return $cache;
}

// ##### Orders scores for the function above #################################
function order_scores($a, $b)
{
	return ($b['count'] < $a['count']) ? -1 : 1;
}

// ##### Find Category Page ###################################################
function findcatpage()
{
	global $vbulletin;

	$categoryid = intval(fetch_bbarray_cookie('arcade_viewdata', 'categoryid'));
	$pagenumber = intval(fetch_bbarray_cookie('arcade_viewdata', 'pagenumber'));

	if ($categoryid AND $pagenumber)
	{
		return "categoryid=$categoryid&pagenumber=$pagenumber";
	}

	return '';
}

// ##### Build Ratings ########################################################
function build_ratings($gameid)
{
	global $db, $vbulletin;

	if ($ratingcount = $db->query_first("
		SELECT SUM(rating) AS votepoints, COUNT(*) AS votecount
		FROM " . TABLE_PREFIX . "v3arcade_ratings
		WHERE gameid = $gameid
	"))
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "v3arcade_games SET
				votepoints = " . $ratingcount['votepoints'] . ",
				votecount = " . $ratingcount['votecount'] . "
			WHERE gameid = $gameid
		");
	}
}

// ##### Check Game Perms #####################################################
function check_canplay($game)
{
	global $vbulletin, $vbphrase, $arcadeadmin;

	if ($arcadeadmin)
	{
		return true;
	}

	if (!$vbulletin->userinfo['userid'])
	{
		$vbulletin->userinfo['posts'] = 0;
		$vbulletin->userinfo['reputation'] = 0;
	}

	// How long has the player been a member?
	$game['membershiplength'] = (TIMENOW - $vbulletin->userinfo['joindate']) / 86400;

	// Minimum post check.
	$minpostneeded = max($game['minpoststotal'], $vbulletin->userinfo['permissions']['minpoststoplay']);
	if ($vbulletin->userinfo['posts'] < $minpostneeded)
	{
		eval(standard_error(fetch_error(
			'v3_not_enough_posts',
			vb_number_format($minpostneeded),
			vb_number_format($vbulletin->userinfo['posts']),
			$game['title']
		)));
	}

	// Minimum reputation check.
	$minrepneeded = max($game['minrep'], $vbulletin->userinfo['permissions']['minreptoplay']);
	if ($vbulletin->options['reputationenable'] AND $vbulletin->userinfo['reputation'] < $minrepneeded)
	{
		eval(standard_error(fetch_error(
			'v3_rep_too_low',
			vb_number_format($minrepneeded),
			vb_number_format($vbulletin->userinfo['reputation']),
			$game['title']
		)));
	}

	// Minimum average posts per day check.
	$game['postsperday'] = $vbulletin->userinfo['posts'] / $game['membershiplength'];
	if ($game['postsperday'] < $game['minpostsperday'])
	{
		eval(standard_error(fetch_error(
			'v3_not_enough_ppd',
			$game['minpostsperday'],
			vb_number_format($game['postsperday']),
			$game['title']
		)));
	}

	// Minimum membership length check.
	$minregneeded = max($game['minreglength'], $vbulletin->userinfo['permissions']['minreglengthtoplay']);
	if (floor($game['membershiplength']) < $minregneeded)
	{
		eval(standard_error(fetch_error(
			'v3_not_registered_for_long_enough',
			$minregneeded,
			floor($game['membershiplength']),
			$game['title']
		)));
	}

	// Minimum posts today check.
	if ($game['minpoststhisday'])
	{
		$postcheck = $vbulletin->db->query_first("
			SELECT COUNT(*) AS count
			FROM " . TABLE_PREFIX . "post
			WHERE userid = " . $vbulletin->userinfo['userid'] . "
				AND dateline < " . TIMENOW . "
				AND dateline > " . (TIMENOW - 86400)
		);
		if ($postcheck['count'] < $game['minpoststhisday'])
		{
			eval(standard_error(fetch_error(
				'v3_not_enough_posts_today',
				$game['minpoststhisday'],
				$postcheck['count'],
				$game['title']
			)));
		}
	}

	return true;
}

// ##### Build Favorites Cache ################################################
function build_favcache()
{
	global $db, $vbulletin;

	$favcache = array();

	$fcq = $db->query_read("
		SELECT * FROM " . TABLE_PREFIX . "v3arcade_favorites
		WHERE userid = " . $vbulletin->userinfo['userid']
	);
	while ($fc = $db->fetch_array($fcq))
	{
		$favcache[$fc['gameid']] = $fc['gameid'];
	}

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "user SET
			favcache = '" . $db->escape_string(serialize($favcache)) . "'
		WHERE userid = " . $vbulletin->userinfo['userid']
	);
}

?>